package gov.va.med.mhv.calendar.converter;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import gov.va.med.mhv.calendar.dto.ToDoTaskDTO;
import gov.va.med.mhv.calendar.model.ToDoTask;

import org.springframework.core.convert.converter.Converter;

public class ToDoTaskConverter implements Converter <ToDoTask, ToDoTaskDTO>{

	@Override
	public ToDoTaskDTO convert(ToDoTask source) {
		ToDoTaskDTO target = new ToDoTaskDTO();
		target.setToDoId(source.getToDoId());
		target.setSubject(source.getSubject());
		target.setDescription(source.getDescription());
		target.setDueDate(source.getDueDate());
		target.setReminderInterval(source.getReminderInterval());
		target.setReminderDate(source.getReminderDate());
		target.setToDoStatus(source.getToDoStatus());
		target.setUserProfileId(source.getUserProfileId());
		
		return target;
	}
	
	public ToDoTask convert(ToDoTaskDTO source) {
		ToDoTask target =  new ToDoTask();
		target.setToDoId(source.getToDoId());
		target.setSubject(source.getSubject());
		target.setDescription(source.getDescription());
		target.setDueDate(source.getDueDate());
		target.setReminderInterval(source.getReminderInterval());
		target.setReminderDate(source.getReminderDate());
		target.setToDoStatus(source.getToDoStatus());
		target.setUserProfileId(source.getUserProfileId());
		target.setOplock(0);
		
		return target;
	}
	

	public List<ToDoTaskDTO> convert(List<ToDoTask> source) {
		List <ToDoTaskDTO> toDoTaskDto= null;
		if(null !=source) {
			toDoTaskDto = new ArrayList<ToDoTaskDTO>();

			for (ToDoTask toDoTask: source) {
				toDoTaskDto.add(this.convert(toDoTask));
			}

		}

		return toDoTaskDto;
	}


}
